package com.yd.product.feign.client.announcementcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.announcementcommissionratio.ApiAnnouncementCommissionRatioFeignFallbackFactory;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioBatchSaveRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioEditRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioPageRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioAddRequest;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 产品服务-公告佣比率规格明细信息Feign客户端
 */
@FeignClient(name = "yd-product-api",path = "/product/api/announcementCommissionRatio",fallbackFactory = ApiAnnouncementCommissionRatioFeignFallbackFactory.class)
public interface ApiAnnouncementCommissionRatioFeignClient {

    /**
     * 分页列表查询-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiAnnouncementCommissionRatioPageRequest request);

    /**
     * 批量保存-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/batch/save")
    Result batchSave(@Validated @RequestBody ApiAnnouncementCommissionRatioBatchSaveRequest request);

    /**
     * 添加-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiAnnouncementCommissionRatioAddRequest request);

    /**
     * 编辑-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/edit")
    Result edit(@Validated @RequestBody ApiAnnouncementCommissionRatioEditRequest request);

    /**
     * 编辑-状态
     * @param announcementCommissionRatioBizId
     * @param status
     * @return
     */
    @PutMapping("/edit/status")
    Result editStatus(@NotBlank(message = "公告佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "announcementCommissionRatioBizId") String announcementCommissionRatioBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);

    /**
     * 详情-公告佣比率规格明细信息
     * @param announcementCommissionRatioBizId 公告佣比率规格明细表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiAnnouncementCommissionRatioDetailResponse> detail(@NotBlank(message = "公告佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "announcementCommissionRatioBizId") String announcementCommissionRatioBizId);

    /**
     * 删除-公告佣比率规格明细信息
     * @param announcementCommissionRatioBizId 公告佣比率规格明细表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "公告佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "announcementCommissionRatioBizId") String announcementCommissionRatioBizId);

    /**
     * 复制-公告佣比率规格明细信息
     * @param announcementCommissionRatioBizId 公告佣比率规格明细表唯一业务ID
     * @return
     */
    @PutMapping("/copy")
    Result copy(@NotBlank(message = "公告佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "announcementCommissionRatioBizId") String announcementCommissionRatioBizId);

    /**
     * 根据条件查询是否有公告佣比率规格明细信息数据
     * @param productLaunchBizId 产品上架信息表唯一业务ID不
     * @return
     */
    @GetMapping("/is/data")
    Result<Boolean> isData(@NotBlank(message = "产品上架信息表唯一业务ID不能为空") @RequestParam(value = "productLaunchBizId") String productLaunchBizId);
}
