package com.yd.product.feign.fallback.productattribute;

import com.yd.common.result.Result;
import com.yd.product.feign.client.productattribute.ApiProductAttributeFeignClient;
import com.yd.product.feign.request.productattribute.ApiProductAttributeSaveRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 产品服务-产品属性信息Feign降级处理
 */
@Slf4j
@Component
public class ApiProductAttributeFeignFallbackFactory implements FallbackFactory<ApiProductAttributeFeignClient> {
    @Override
    public ApiProductAttributeFeignClient create(Throwable cause) {
        return new ApiProductAttributeFeignClient() {
            @Override
            public Result save(ApiProductAttributeSaveRequest request) {
                return null;
            }
        };
    }
}
