package com.yd.product.feign.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class CustomLocalDateTimeDeserializer extends JsonDeserializer<LocalDateTime> {
    @Override
    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String dateStr = p.getText();
        // 如果只包含日期，自动添加时间部分
        if (dateStr.length() == 10) { // "yyyy-MM-dd"
            LocalDate date = LocalDate.parse(dateStr);
            return date.atStartOfDay();
        }
        // 否则按原格式解析
        return LocalDateTime.parse(dateStr);
    }
}