package com.yd.product.api;

import com.yd.common.constant.ServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication(scanBasePackages = "com.yd")
@MapperScan("com.yd.**.dao")
@EnableFeignClients(basePackages = "com.yd")
public class ProductApiApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(ProductApiApplication.class)
                .properties("spring.application.name="+ ServerNameConstants.ydProductApi)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-product-api启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
