package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 上架产品规格配置表（新表）
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("species_setting")
public class SpeciesSetting implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品上架规格配置表唯一业务ID
     */
    @TableField("species_setting_biz_id")
    private String speciesSettingBizId;

    /**
     * 产品上架信息表唯一业务ID（冗余）
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 规格表唯一业务ID（冗余）
     */
    @TableField("species_biz_id")
    private String speciesBizId;

    /**
     * 规格类型表唯一业务ID
     */
    @TableField("species_type_biz_id")
    private String speciesTypeBizId;

    /**
     * 规格类型编码
     */
    @TableField("type_code")
    private String typeCode;

    /**
     * 规格类型名称
     */
    @TableField("type_name")
    private String typeName;

    /**
     * 规格值
     */
    @TableField("value")
    private String value;

    /**
     * 是否配图 0-否 1-是
     */
    @TableField("is_illustration")
    private String isIllustration;

    /**
     * 配图url
     */
    @TableField("illustration_url")
    private String illustrationUrl;

    /**
     * 是否自定义 0-否 1-是
     */
    @TableField("is_customize")
    private String isCustomize;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
