package com.yd.product.feign.response.expectedspecies;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiExpectedSpeciesListResponse {

    /**
     * 来佣比率规格表唯一业务ID
     */
    private String expectedSpeciesBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 产品唯一业务ID
     */
    private String productBizId;

    /**
     * 规格条件列表JSON串
     */
    private String speciesJson;

    /**
     * 保障计划（0-64岁等）(固定规格条件)
     */
    private String protectionPlan;

    /**
     * 供款年期（5、10、20年期等）(固定规格条件)
     */
    private String paymentTerm;

    /**
     * 来佣比率规格明细表唯一业务ID
     */
    private String expectedCommissionRatioBizId;

    /**
     * 费用名称（转介费等）
     */
    private String expenseName;

    /**
     * 佣金年限（起）
     */
    private String startPeriod;

    /**
     * 佣金年限（止）
     */
    private String endPeriod;

    /**
     * 佣金期数
     */
    private String issueNumber;

    /**
     * 标保折算比例（基本保费）
     */
    private BigDecimal discountRatio;

    /**
     * 计算基数（保费/保费*折算比例）
     */
    private BigDecimal cardinalNumber;

    /**
     * 佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 有效开始时间
     */
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    private LocalDateTime effectiveEnd;

    /**
     * 是否受汇率影响 0-否 1-是，字典）
     */
    private String isExchangeRate;

    /**
     * 结算币种（字典）
     */
    private String currency;

    /**
     * 是否直签 (0-否 1-是，字典)
     */
    private String isDirectSign;

    /**
     * 对账公司id(部门id)
     */
    private String reconciliationCompany;

    /**
     * 对账公司名称(部门名称)
     */
    private String reconciliationCompanyName;

    /**
     * 销售组织id(部门id)
     */
    private String salesOrg;

    /**
     * 销售组织名称(部门名称)
     */
    private String salesOrgName;
}
