package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.common.result.Result;
import com.yd.product.service.model.RelTenantProductLaunch;
import com.yd.product.service.dao.RelTenantProductLaunchMapper;
import com.yd.product.service.service.IRelTenantProductLaunchService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 租户-产品上架信息关系表（新表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class RelTenantProductLaunchServiceImpl extends ServiceImpl<RelTenantProductLaunchMapper, RelTenantProductLaunch> implements IRelTenantProductLaunchService {

    @Override
    public Boolean delByProductLaunchBizId(String productLaunchBizId) {
        return this.remove(new LambdaQueryWrapper<RelTenantProductLaunch>().eq(RelTenantProductLaunch::getProductLaunchBizId,productLaunchBizId));
    }
}
