package com.yd.product.feign.request.announcementcommissionratio;

import com.yd.product.feign.dto.ApiAnnouncementCommissionRatioDto;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiAnnouncementCommissionRatioSaveRequest {

    /**
     * 产品上架信息表唯一业务ID
     */
    @NotBlank(message = "产品上架信息表唯一业务ID不能为空")
    private String productLaunchBizId;

    /**
     * 公告佣比率信息配置列表
     */
    @NotEmpty(message = "公告佣比率信息配置列表不能为空")
    private List<ApiAnnouncementCommissionRatioDto> apiAnnouncementCommissionRatioDtoList;
}
