package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 租户-产品关系表（原有表）
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("rel_tenant_product")
public class RelTenantProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 租户ID（业务id）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 产品唯一业务ID
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 状态(0:禁用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
