package com.yd.product.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.feign.client.relobjectcategory.ApiRelObjectCategoryFeignClient;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryListAddRequest;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.product.api.service.ApiProductLaunchService;
import com.yd.product.api.service.ApiProductService;
import com.yd.product.feign.dto.ApiProductLaunchDto;
import com.yd.product.feign.dto.ApiSpeciesPriceDto;
import com.yd.product.feign.dto.ApiSpeciesTypeDto;
import com.yd.product.feign.request.product.ApiProductAddRequest;
import com.yd.product.feign.request.product.ApiProductEditRequest;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchCategoryAddRequest;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchPageRequest;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchSaveRequest;
import com.yd.product.feign.response.productlaunch.ApiAttributeSettingDto;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchCategoryAddResponse;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchDetailResponse;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchPageResponse;
import com.yd.product.service.dto.AttributeSettingDto;
import com.yd.product.service.dto.SpeciesPriceDto;
import com.yd.product.service.dto.SpeciesSettingDto;
import com.yd.product.service.model.*;
import com.yd.product.service.service.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiProductLaunchServiceImpl implements ApiProductLaunchService {

    @Autowired
    private IProductLaunchService iProductLaunchService;

    @Autowired
    private ApiProductService apiProductService;

    @Autowired
    private IProductService iProductService;

    @Autowired
    private IAttributeSettingService iAttributeSettingService;

    @Autowired
    private ISpeciesSettingService iSpeciesSettingService;

    @Autowired
    private ISpeciesPriceService iSpeciesPriceService;

    @Autowired
    private ApiRelObjectCategoryFeignClient apiRelObjectCategoryFeignClient;

    @Override
    public Result<IPage<ApiProductLaunchPageResponse>> page(ApiProductLaunchPageRequest request) {
        Page<ApiProductLaunchPageResponse> page = new Page<ApiProductLaunchPageResponse>(request.getPageNo(), request.getPageSize());
        IPage<ApiProductLaunchPageResponse> iPage = iProductLaunchService.page(page, request);
        return Result.success(iPage);
    }
    /**
     * 添加-产品上架类目信息
     * @param request
     * @return
     */
    @Override
    public Result<ApiProductLaunchCategoryAddResponse> addCategory(ApiProductLaunchCategoryAddRequest request) {
        ApiProductLaunchCategoryAddResponse response = new ApiProductLaunchCategoryAddResponse();
        if (StringUtils.isNotBlank(request.getProductBizId())) {
            //产品唯一业务ID不为空，校验产品信息是否存在
            Product product = iProductService.queryOne(request.getProductBizId());
            if (Objects.isNull(product)) {
                //数据不存在
                throw new BusinessException("产品信息数据不存在");
            }
        }
        String productBizId = "";
        //保存产品基础信息
        if (Objects.isNull(request.getProductBizId())) {
            //新增产品基础信息
            Result<String> result = apiProductService.add(ApiProductAddRequest.builder()
                    .productName(request.getProductName())
                    .build());
            productBizId = result.getData();
        }else {
            //编辑产品基础信息
            Result<String> result = apiProductService.edit(ApiProductEditRequest.builder()
                    .productName(request.getProductName())
                    .build());
            productBizId = result.getData();
        }

        //添加产品上架信息
        ProductLaunch productLaunch = new ProductLaunch();
        productLaunch.setTitle(request.getProductName());
        productLaunch.setMainUrls(String.join(";",request.getMainUrlsList()));
        productLaunch.setProductBizId(productBizId);
        //产品上架信息表唯一业务ID
        productLaunch.setProductLaunchBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_PRODUCT_LAUNCH.getCode()));
        //待审核
        productLaunch.setStatus(0);
        iProductLaunchService.saveOrUpdate(productLaunch);
        //添加产品上架对象分类关系信息
        ApiRelObjectCategoryListAddRequest addRequest = new ApiRelObjectCategoryListAddRequest();
        addRequest.setCategoryBizIdList(request.getCategoryBizIdList());
        addRequest.setObjectBizId(productLaunch.getProductLaunchBizId());
        addRequest.setObjectName(productLaunch.getTitle());
        addRequest.setObjectTableName(CommonEnum.UID_TYPE_PRODUCT_LAUNCH.getCode());
        addRequest.setObjectType(CommonEnum.UID_TYPE_PRODUCT_LAUNCH.getCode());
        apiRelObjectCategoryFeignClient.addRelObjectCategoryList(addRequest);

        response.setProductBizId(productBizId);
        response.setProductLaunchBizId(productLaunch.getProductLaunchBizId());
        return Result.success();
    }

    /**
     * 详情-产品上架信息
     * @param productLaunchBizId 产品上架信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiProductLaunchDetailResponse> detail(String productLaunchBizId) {
        ApiProductLaunchDetailResponse response = new ApiProductLaunchDetailResponse();
        ProductLaunch productLaunch = iProductLaunchService.queryOne(productLaunchBizId);
        if (Objects.isNull(productLaunch)) {
            throw new BusinessException("产品上架信息不存在");
        }
        //产品上架主信息
        ApiProductLaunchDto apiProductLaunchDto = new ApiProductLaunchDto();
        BeanUtils.copyProperties(productLaunch,apiProductLaunchDto);
        //详情图列表
        apiProductLaunchDto.setDetailUrlsList(StringUtils.isNotBlank(productLaunch.getDetailUrls()) ? Arrays.asList(productLaunch.getDetailUrls().split(";").clone()) : new ArrayList<>());
        //主图url列表
        apiProductLaunchDto.setMainUrlsList(StringUtils.isNotBlank(productLaunch.getMainUrls()) ? Arrays.asList(productLaunch.getMainUrls().split(";").clone()) : new ArrayList<>());
        response.setApiProductLaunchDto(apiProductLaunchDto);

        //设置的产品上架信息的参数列表
        List<ApiAttributeSettingDto> apiAttributeSettingDtoList = new ArrayList<>();
        List<AttributeSetting> attributeSettingList = iAttributeSettingService.queryList(AttributeSettingDto.builder()
                .productLaunchBizId(productLaunchBizId)
                .build());
        if (!CollectionUtils.isEmpty(attributeSettingList)) {
            apiAttributeSettingDtoList = attributeSettingList.stream().map(dto -> {
                ApiAttributeSettingDto settingDto = new ApiAttributeSettingDto();
                BeanUtils.copyProperties(dto,settingDto);
                return settingDto;
            }).collect(Collectors.toList());
        }
        response.setApiAttributeSettingDtoList(apiAttributeSettingDtoList);

        //规格信息配置列表
        List<ApiSpeciesTypeDto> apiSpeciesTypeDtoList = new ArrayList<>();
        List<SpeciesSetting> speciesSettingList = iSpeciesSettingService.queryList(SpeciesSettingDto.builder().productLaunchBizId(productLaunchBizId).build());
        if (!CollectionUtils.isEmpty(speciesSettingList)) {
            apiSpeciesTypeDtoList = speciesSettingList.stream().map(dto -> {
                ApiSpeciesTypeDto typeDto = new ApiSpeciesTypeDto();
                BeanUtils.copyProperties(dto,typeDto);
                return typeDto;
            }).collect(Collectors.toList());
        }
        response.setApiSpeciesTypeDtoList(apiSpeciesTypeDtoList);

        //规格价格配置列表
        List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList = new ArrayList<>();
        List<SpeciesPrice> speciesPriceList = iSpeciesPriceService.queryList(SpeciesPriceDto.builder().productLaunchBizId(productLaunchBizId).build());
        if (!CollectionUtils.isEmpty(speciesPriceList)) {
            apiSpeciesPriceDtoList = speciesPriceList.stream().map(dto -> {
                ApiSpeciesPriceDto priceDto = new ApiSpeciesPriceDto();
                BeanUtils.copyProperties(dto,priceDto);
                return priceDto;
            }).collect(Collectors.toList());
        }
        response.setApiSpeciesPriceDtoList(apiSpeciesPriceDtoList);

        return Result.success(response);
    }

    /**
     * 保存-产品上架信息
     * @param request
     * @return
     */
    @Override
    public Result save(ApiProductLaunchSaveRequest request) {
        return null;
    }

}
