package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioPageRequest;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioPageResponse;
import com.yd.product.service.model.AnnouncementCommissionRatio;
import com.yd.product.service.dao.AnnouncementCommissionRatioMapper;
import com.yd.product.service.model.AnnouncementSpecies;
import com.yd.product.service.service.IAnnouncementCommissionRatioService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 公告佣比率规格明细表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-27
 */
@Service
public class AnnouncementCommissionRatioServiceImpl extends ServiceImpl<AnnouncementCommissionRatioMapper, AnnouncementCommissionRatio> implements IAnnouncementCommissionRatioService {

    @Override
    public IPage<ApiAnnouncementCommissionRatioPageResponse> page(Page<ApiAnnouncementCommissionRatioPageResponse> page,
                                                                  ApiAnnouncementCommissionRatioPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public AnnouncementCommissionRatio queryOne(String announcementCommissionRatioBizId) {
        return this.getOne(new LambdaQueryWrapper<AnnouncementCommissionRatio>().eq(AnnouncementCommissionRatio::getAnnouncementCommissionRatioBizId,announcementCommissionRatioBizId));
    }

    @Override
    public Boolean del(List<String> announcementSpeciesBizIdList) {
        return this.remove(new LambdaQueryWrapper<AnnouncementCommissionRatio>()
                .in(AnnouncementCommissionRatio::getAnnouncementSpeciesBizId,announcementSpeciesBizIdList));
    }
}
