package com.yd.product.feign.request.expectedcommissionratio;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiExpectedCommissionRatioAddRequest {

    /**
     * 来佣比率规格表唯一业务ID
     */
    @NotBlank(message = "来佣比率规格表唯一业务ID")
    private String expectedSpeciesBizId;

    /**
     * 费用名称（转介费等）
     */
    @NotBlank(message = "来佣比率规格表唯一业务ID")
    private String expenseName;

    /**
     * 佣金年限（起）
     */
    private String startPeriod;

    /**
     * 佣金年限（止）
     */
    private String endPeriod;

    /**
     * 标保折算比例（基本保费）
     */
    private BigDecimal discountRatio;

    /**
     * 佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 有效开始时间
     */
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    private LocalDateTime effectiveEnd;

    /**
     * 是否受汇率影响 0-否 1-是，字典）
     */
    private String isExchangeRate;

    /**
     * 结算币种（字典）
     */
    private String currency;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 销售组织
     */
    private String salesOrg;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;
}
