package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioPageResponse;
import com.yd.product.service.model.ExpectedCommissionRatio;
import com.yd.product.service.dao.ExpectedCommissionRatioMapper;
import com.yd.product.service.service.IExpectedCommissionRatioService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 预计来佣比率表（新表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class ExpectedCommissionRatioServiceImpl extends ServiceImpl<ExpectedCommissionRatioMapper, ExpectedCommissionRatio> implements IExpectedCommissionRatioService {

    @Override
    public IPage<ApiExpectedCommissionRatioPageResponse> page(Page<ApiExpectedCommissionRatioPageResponse> page,
                                                              ApiExpectedCommissionRatioPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public ExpectedCommissionRatio queryOne(String expectedCommissionRatioBizId) {
        return this.getOne(new LambdaQueryWrapper<ExpectedCommissionRatio>().eq(ExpectedCommissionRatio::getExpectedCommissionRatioBizId,expectedCommissionRatioBizId));
    }
}
