package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 公告佣比率规格表
 * </p>
 *
 * @author zxm
 * @since 2025-12-01
 */
@Getter
@Setter
@TableName("announcement_species")
public class AnnouncementSpecies implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 公告佣比率规格表唯一业务ID
     */
    @TableField("announcement_species_biz_id")
    private String announcementSpeciesBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 产品唯一业务ID
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 规格条件列表JSON串
     */
    @TableField("species_json")
    private String speciesJson;

    /**
     * 保障计划（0-64岁等）(固定规格条件)
     */
    @TableField("protection_plan")
    private String protectionPlan;

    /**
     * 供款年期（5、10、20年期等）(固定规格条件)
     */
    @TableField("payment_term")
    private String paymentTerm;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 创建人名称
     */
    @TableField("creator_name")
    private String creatorName;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 更新人名称
     */
    @TableField("updater_name")
    private String updaterName;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
