package com.yd.product.api.service.impl;

import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.product.api.service.ApiSpeciesSettingService;
import com.yd.product.feign.dto.ApiSpeciesSettingDto;
import com.yd.product.service.model.SpeciesSetting;
import com.yd.product.service.service.ISpeciesSettingService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiSpeciesSettingServiceImpl implements ApiSpeciesSettingService {

    @Autowired
    private ISpeciesSettingService iSpeciesSettingService;

    /**
     * 保存产品上架规格配置列表
     * @param apiSpeciesSettingDtoList
     * @param productLaunchBizId
     * @return
     */
    @Override
    public Result save(List<ApiSpeciesSettingDto> apiSpeciesSettingDtoList,
                       String productLaunchBizId) {
        //先删后新增
        iSpeciesSettingService.delByProductLaunchBizId(productLaunchBizId);

        //新增
        if (!CollectionUtils.isEmpty(apiSpeciesSettingDtoList)) {
            List<SpeciesSetting> speciesSettingList= apiSpeciesSettingDtoList.stream().map(dto -> {
                SpeciesSetting speciesSetting = new SpeciesSetting();
                BeanUtils.copyProperties(dto,speciesSetting);
                //产品上架信息表唯一业务ID
                speciesSetting.setProductLaunchBizId(productLaunchBizId);
                //产品上架规格配置表唯一业务ID
                speciesSetting.setSpeciesSettingBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_SPECIES_SETTING.getCode()));
                return speciesSetting;
            }).collect(Collectors.toList());
            iSpeciesSettingService.saveOrUpdateBatch(speciesSettingList);
        }
        return Result.success();
    }
}
