package com.yd.product.feign.client.expectedcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.expectedcommissionratio.ApiExpectedCommissionRatioFeignFallbackFactory;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 产品服务-预计来佣比率信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiExpectedCommissionRatioFeignFallbackFactory.class)
public interface ApiExpectedCommissionRatioFeignClient {

    /**
     * 分页列表查询-预计来佣比率信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiExpectedCommissionRatioPageRequest request);
}
