package com.yd.product.feign.fallback.expectedcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.client.expectedcommissionratio.ApiExpectedCommissionRatioFeignClient;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 产品服务-预计来佣比率信息Feign降级处理
 */
@Slf4j
@Component
public class ApiExpectedCommissionRatioFeignFallbackFactory implements FallbackFactory<ApiExpectedCommissionRatioFeignClient> {
    @Override
    public ApiExpectedCommissionRatioFeignClient create(Throwable cause) {
        return new ApiExpectedCommissionRatioFeignClient() {
            @Override
            public Result page(ApiExpectedCommissionRatioPageRequest request) {
                return null;
            }
        };
    }
}
