package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiRelProjectProductLaunchService;
import com.yd.product.feign.client.relprojectproductlaunch.ApiRelProjectProductLaunchFeignClient;
import com.yd.product.feign.request.relprojectproductlaunch.ApiRelProjectProductLaunchPageRequest;
import com.yd.product.feign.response.relprojectproductlaunch.ApiRelProjectProductLaunchPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 项目-产品上架关系信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/relProjectProductLaunch")
@Validated
public class ApiRelProjectProductLaunchController implements ApiRelProjectProductLaunchFeignClient {

    @Autowired
    private ApiRelProjectProductLaunchService apiRelProjectProductLaunchService;

    /**
     * 分页列表查询-租户项目产品上架关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectProductLaunchPageResponse>> page(ApiRelProjectProductLaunchPageRequest request) {
        return apiRelProjectProductLaunchService.page(request);
    }


}
