package com.yd.product.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.product.api.service.ApiSpeciesPriceService;
import com.yd.product.feign.dto.ApiSpeciesPriceDto;
import com.yd.product.feign.dto.ApiSpeciesSettingDto;
import com.yd.product.service.dto.SpeciesPriceDto;
import com.yd.product.service.model.SpeciesPrice;
import com.yd.product.service.service.ISpeciesPriceService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiSpeciesPriceServiceImpl implements ApiSpeciesPriceService {

    @Autowired
    private ISpeciesPriceService iSpeciesPriceService;

    /**
     * 保存规格价格配置列表
     * @param apiSpeciesPriceDtoList
     * @param productLaunchBizId
     * @return
     */
    @Override
    public Result save(List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList,
                       String productLaunchBizId) {
        //先删后新增
        iSpeciesPriceService.delByProductLaunchBizId(productLaunchBizId);

        //新增
        if (!CollectionUtils.isEmpty(apiSpeciesPriceDtoList)) {
            List<SpeciesPrice> speciesPriceList= apiSpeciesPriceDtoList.stream().map(dto -> {
                SpeciesPrice speciesPrice = new SpeciesPrice();
                BeanUtils.copyProperties(dto,speciesPrice);
                //产品上架信息表唯一业务ID
                speciesPrice.setProductLaunchBizId(productLaunchBizId);
                //规格价格维护表唯一业务ID
                speciesPrice.setSpeciesPriceBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_SPECIES_PRICE.getCode()));
                //上架产品规格配置表信息JSON串
                speciesPrice.setSpeciesJson(!CollectionUtils.isEmpty(dto.getApiSpeciesSettingDtoList()) ? JSON.toJSONString(dto.getApiSpeciesSettingDtoList()) : "");
                return speciesPrice;
            }).collect(Collectors.toList());
            iSpeciesPriceService.saveOrUpdateBatch(speciesPriceList);
        }
        return Result.success();
    }

    /**
     * 查询规格价格配置列表
     * @param productLaunchBizId
     * @return
     */
    @Override
    public List<ApiSpeciesPriceDto> querySpeciesPriceDtoList(String productLaunchBizId) {
        List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList = new ArrayList<>();
        List<SpeciesPrice> speciesPriceList = iSpeciesPriceService.queryList(SpeciesPriceDto.builder().productLaunchBizId(productLaunchBizId).build());
        if (!CollectionUtils.isEmpty(speciesPriceList)) {
            apiSpeciesPriceDtoList = speciesPriceList.stream().map(dto -> {
                ApiSpeciesPriceDto priceDto = new ApiSpeciesPriceDto();
                BeanUtils.copyProperties(dto,priceDto);
                priceDto.setApiSpeciesSettingDtoList(StringUtils.isNotBlank(dto.getSpeciesJson()) ? JSON.parseArray(dto.getSpeciesJson(), ApiSpeciesSettingDto.class) : new ArrayList<>());
                return priceDto;
            }).collect(Collectors.toList());
        }
        return apiSpeciesPriceDtoList;
    }
}
