package com.yd.product.feign.fallback.announcementspecies;

import com.yd.common.result.Result;
import com.yd.product.feign.client.announcementspecies.ApiAnnouncementSpeciesFeignClient;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesDetailPageRequest;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesImportRequest;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 产品服务-公告佣比率规格信息Feign降级处理
 */
@Slf4j
@Component
public class ApiAnnouncementSpeciesFeignFallbackFactory implements FallbackFactory<ApiAnnouncementSpeciesFeignClient> {
    @Override
    public ApiAnnouncementSpeciesFeignClient create(Throwable cause) {
        return new ApiAnnouncementSpeciesFeignClient() {
            @Override
            public Result page(ApiAnnouncementSpeciesPageRequest request) {
                return null;
            }

            @Override
            public Result importSpecies(ApiAnnouncementSpeciesImportRequest request) {
                return null;
            }

            @Override
            public Result delSpecies(String announcementSpeciesBizId) {
                return null;
            }

            @Override
            public Result page(ApiAnnouncementSpeciesDetailPageRequest request) {
                return null;
            }
        };
    }
}
