package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 产品上架信息表
 * </p>
 *
 * @author zxm
 * @since 2025-11-27
 */
@Getter
@Setter
@TableName("product_launch")
public class ProductLaunch implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品上架信息表唯一业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 关联产品表唯一业务ID（上架的产品）
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 标题
     */
    @TableField("title")
    private String title;

    /**
     * 短标题
     */
    @TableField("short_title")
    private String shortTitle;

    /**
     * 主图url（多个url用分号分隔）
     */
    @TableField("main_urls")
    private String mainUrls;

    /**
     * 详情图（多个url用分号分隔）
     */
    @TableField("detail_urls")
    private String detailUrls;

    /**
     * 详情描述
     */
    @TableField("detail_description")
    private String detailDescription;

    /**
     * 是否定时开售 0-否 1-是
     */
    @TableField("is_timing")
    private String isTiming;

    /**
     * 开售日期
     */
    @TableField("release_date")
    private LocalDateTime releaseDate;

    /**
     * 是否隐藏价格（是否定时开售为是的时候才设置这个） 0-否 1-是
     */
    @TableField("is_hidden_price")
    private String isHiddenPrice;

    /**
     * 是否限购 0-否 1-是
     */
    @TableField("is_purchase_limit")
    private String isPurchaseLimit;

    /**
     * 限购日期单位 DAILY-每日 WEEKLY-每周 MONTHLY-每月 YEARLY-每年
     */
    @TableField("limit_date_unit")
    private String limitDateUnit;

    /**
     * 限购数量
     */
    @TableField("limit_quantity")
    private Integer limitQuantity;

    /**
     * 是否假一赔三 0-否 1-是
     */
    @TableField("is_pay_three")
    private String isPayThree;

    /**
     * 是否坏损包赔 0-否 1-是
     */
    @TableField("is_damaged")
    private String isDamaged;

    /**
     * 是否支持换货 0-否 1-是
     */
    @TableField("is_exchange")
    private String isExchange;

    /**
     * 7天无理由
     */
    @TableField("seven")
    private String seven;

    /**
     * 发货途径
     */
    @TableField("delivery_route")
    private String deliveryRoute;

    /**
     * 物流配送
     */
    @TableField("logistics_distribution")
    private String logisticsDistribution;

    /**
     * 售后说明
     */
    @TableField("after_sales_instructions")
    private String afterSalesInstructions;

    /**
     * 状态：DSH-待审核 CG-审核成功 SB-审核失败 ZS-在售 TS-停售 XJ-下架 YS-预售 DKS-待开售
     */
    @TableField("status")
    private String status;

    /**
     * 审核备注
     */
    @TableField("approval_remark")
    private String approvalRemark;

    /**
     * 上架到对应的项目列表（多个项目id分号分隔）（冗余）
     */
    @TableField("project_biz_id_list")
    private String projectBizIdList;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @TableField("scope")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
