package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.product.service.model.RelProjectProduct;
import com.yd.product.service.dao.RelProjectProductMapper;
import com.yd.product.service.service.IRelProjectProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 项目-产品关系表（原有表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class RelProjectProductServiceImpl extends ServiceImpl<RelProjectProductMapper, RelProjectProduct> implements IRelProjectProductService {

    @Override
    public Boolean delByProductBizId(String productBizId) {
        return this.remove(new LambdaQueryWrapper<RelProjectProduct>().eq(RelProjectProduct::getProductBizId,productBizId));
    }
}
