package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.product.service.model.RelTenantProduct;
import com.yd.product.service.dao.RelTenantProductMapper;
import com.yd.product.service.service.IRelTenantProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 租户-产品关系表（原有表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class RelTenantProductServiceImpl extends ServiceImpl<RelTenantProductMapper, RelTenantProduct> implements IRelTenantProductService {

    @Override
    public Boolean delByProductBizId(String productBizId) {
        return this.remove(new LambdaQueryWrapper<RelTenantProduct>().eq(RelTenantProduct::getProductBizId,productBizId));
    }
}
