package com.yd.product.feign.client.expectedcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.expectedcommissionratio.ApiExpectedCommissionRatioFeignFallbackFactory;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioBatchSaveRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioAddRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioBatchSaveRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioEditRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 产品服务-来佣比率规格明细信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiExpectedCommissionRatioFeignFallbackFactory.class)
public interface ApiExpectedCommissionRatioFeignClient {

    /**
     * 分页列表查询-来佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiExpectedCommissionRatioPageRequest request);

    /**
     * 批量保存-来佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/batch/save")
    Result batchSave(@Validated @RequestBody ApiExpectedCommissionRatioBatchSaveRequest request);

    /**
     * 添加-来佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiExpectedCommissionRatioAddRequest request);

    /**
     * 编辑-来佣比率规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/edit")
    Result edit(@Validated @RequestBody ApiExpectedCommissionRatioEditRequest request);

    /**
     * 编辑-状态
     * @param expectedCommissionRatioBizId
     * @param status
     * @return
     */
    @PutMapping("/edit/status")
    Result editStatus(@NotBlank(message = "来佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "expectedCommissionRatioBizId") String expectedCommissionRatioBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);

    /**
     * 详情-来佣比率规格明细信息
     * @param expectedCommissionRatioBizId 来佣比率规格明细表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiExpectedCommissionRatioDetailResponse> detail(@NotBlank(message = "来佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "expectedCommissionRatioBizId") String expectedCommissionRatioBizId);

    /**
     * 删除-来佣比率规格明细信息
     * @param expectedCommissionRatioBizId 来佣比率规格明细表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "来佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "expectedCommissionRatioBizId") String expectedCommissionRatioBizId);

    /**
     * 复制-来佣比率规格明细信息
     * @param expectedSpeciesBizId 来佣比率规格明细表唯一业务ID
     * @return
     */
    @PutMapping("/copy")
    Result copy(@NotBlank(message = "来佣比率规格明细表唯一业务ID不能为空") @RequestParam(value = "expectedSpeciesBizId") String expectedSpeciesBizId);
}
