package com.yd.question.feign.client;

import com.yd.common.result.Result;
import com.yd.question.feign.dto.ApiAnswerSessionsDto;
import com.yd.question.feign.fallback.ApiQuestionnairesFeignFallbackFactory;
import com.yd.question.feign.request.ApiAnswerSaveRequest;
import com.yd.question.feign.request.ApiBatchSaveAnswerRequest;
import com.yd.question.feign.request.ApiObjectSaveRequest;
import com.yd.question.feign.response.ApiAnswerSaveResponse;
import com.yd.question.feign.response.ApiQuestionnairesDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 问题基础服务-问卷信息Feign客户端
 */
@FeignClient(name = "yd-question-api",path = "/question/api/questionnaires",fallbackFactory = ApiQuestionnairesFeignFallbackFactory.class)
public interface ApiQuestionnairesFeignClient {

    /**
     * 获取问卷详细信息-单个问卷详细信息
     * @param questionnaireBizId 问卷唯一业务ID
     * @param objectBizId 对象业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiQuestionnairesDetailResponse> detail(@RequestParam(value = "questionnaireBizId") String questionnaireBizId,
                                                   @RequestParam(value = "objectBizId") String objectBizId);

    /**
     * 问卷-答题提交接口
     * @return
     */
    @PostMapping("/answer/save")
    Result<ApiAnswerSaveResponse> answerSave(@Validated @RequestBody ApiAnswerSaveRequest request);

    /**
     * 获取问卷-答题会话接口
     * @param questionnaireBizId 问卷唯一业务ID
     * @param objectBizId 对象业务ID
     * @return
     */
    @GetMapping("/answer_session")
    Result<ApiAnswerSessionsDto> answerSession(@RequestParam(value = "questionnaireBizId") String questionnaireBizId,
                                               @RequestParam(value = "objectBizId") String objectBizId);

    /**
     * 问卷-业务对象绑定
     * @return
     */
    @PostMapping("/object/save")
    Result objectSave(@Validated @RequestBody ApiObjectSaveRequest request);

    /**
     * 问卷-批量复制新增答题会话
     * @return
     */
    @PostMapping("/batch/save/answer")
    Result batchSaveAnswer(@Validated @RequestBody ApiBatchSaveAnswerRequest request);
}
