package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.service.model.RelQuestionnaireQuestions;
import com.yd.question.service.model.RelQuestionsOptions;
import com.yd.question.service.dao.RelQuestionsOptionsMapper;
import com.yd.question.service.service.IRelQuestionsOptionsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 问题选项关联表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-16
 */
@Service
public class RelQuestionsOptionsServiceImpl extends ServiceImpl<RelQuestionsOptionsMapper, RelQuestionsOptions> implements IRelQuestionsOptionsService {

    /**
     * 查询列表
     * @param questionnaireBizId 问卷唯一业务ID
     * @param questionBizId 问题唯一业务ID
     * @return
     */
    @Override
    public List<RelQuestionsOptions> queryList(String questionnaireBizId, String questionBizId) {
        List<RelQuestionsOptions> list = baseMapper.selectList(new LambdaQueryWrapper<RelQuestionsOptions>()
                .eq(StringUtils.isNotBlank(questionnaireBizId),RelQuestionsOptions::getQuestionnaireBizId,questionnaireBizId)
                .eq(StringUtils.isNotBlank(questionBizId),RelQuestionsOptions::getQuestionBizId,questionBizId)
        );
        return list;
    }

}
