package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.service.model.RelOptionsAddQuestions;
import com.yd.question.service.dao.RelOptionsAddQuestionsMapper;
import com.yd.question.service.model.RelQuestionsOptions;
import com.yd.question.service.service.IRelOptionsAddQuestionsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 选项和附加问题关联表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-16
 */
@Service
public class RelOptionsAddQuestionsServiceImpl extends ServiceImpl<RelOptionsAddQuestionsMapper, RelOptionsAddQuestions> implements IRelOptionsAddQuestionsService {

    /**
     * 查询列表
     * @param questionnaireBizId
     * @param questionBizId
     * @param optionBizId
     * @return
     */
    @Override
    public List<RelOptionsAddQuestions> queryList(String questionnaireBizId,
                                               String questionBizId,
                                               String optionBizId) {
        List<RelOptionsAddQuestions> list = baseMapper.selectList(new LambdaQueryWrapper<RelOptionsAddQuestions>()
                .eq(StringUtils.isNotBlank(questionnaireBizId),RelOptionsAddQuestions::getQuestionnaireBizId,questionnaireBizId)
                .eq(StringUtils.isNotBlank(questionBizId),RelOptionsAddQuestions::getQuestionBizId,questionBizId)
                .eq(StringUtils.isNotBlank(optionBizId),RelOptionsAddQuestions::getOptionBizId,optionBizId)
        );
        return list;
    }
}
