package com.yd.question.feign.dto;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.IOException;
import java.util.List;

/**
 * 答题会话表DTO（实际回答的内容）
 */
@Data
public class ApiAnswerSessionsDto {

    /**
     * 答题会话表主键id
     */
    private Long id;

    /**
     * 答题会话唯一业务ID
     */
    private String sessionId;

    /**
     * 答题的对象业务ID
     */
    private String objectBizId;

    /**
     * 答题选择的问卷唯一业务ID
     */
    private String questionnaireBizId;

    /**
     * 答题选择的问题唯一业务ID
     */
    @NotBlank(message = "答题选择的问题唯一业务ID不能为空")
    private String questionBizId;

    /**
     * 问题的答题内容（问答题） 非json的文本
     */
    private String questionText;

    /**
     * 问题的答题内容（问答题）JSON串  例：[{"title": "病况1","content": "111"},{"title": "病况2","content": "222"}]
     */
    private String questionTextJson;

    /**
     * 问题的答题内容（问答题）List集合
     */
    private List<ApiQuestionTextJsonDto> questionTextJsonDtoList;

    /**
     * 答题选择的选项json串（包含附加问题答题内容）, 例：[{"option_biz_id": "option_1001","content": "是",[{"add_questions_biz_id": "add_1001","content": "5年"}]},]
     */
    private String optionJson;

    /**
     * 答题选择的选项 List集合
     */
    private List<ApiOptionJsonDto> optionJsonDtoList;

    /**
     * 答题状态(0:草稿 1:已完成 2:未完成)
     */
    private Integer status;


    private static final ObjectMapper objectMapper = new ObjectMapper();

    /**
     * 将questionTextJson转换为List<ApiQuestionTextJsonDto>
     */
    public List<ApiQuestionTextJsonDto> getQuestionTextJsonDtoList() {
        if (questionTextJsonDtoList == null && questionTextJson != null) {
            try {
                questionTextJsonDtoList = objectMapper.readValue(
                        questionTextJson,
                        new TypeReference<List<ApiQuestionTextJsonDto>>(){}
                );
            } catch (IOException e) {
                throw new RuntimeException("Failed to parse questionTextJson", e);
            }
        }
        return questionTextJsonDtoList;
    }

    /**
     * 将optionJson转换为List<ApiOptionJsonDto>
     */
    public List<ApiOptionJsonDto> getOptionJsonDtoList() {
        if (optionJsonDtoList == null && optionJson != null) {
            try {
                optionJsonDtoList = objectMapper.readValue(
                        optionJson,
                        new TypeReference<List<ApiOptionJsonDto>>(){}
                );
            } catch (IOException e) {
                throw new RuntimeException("Failed to parse optionJson", e);
            }
        }
        return optionJsonDtoList;
    }
}
