package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.service.model.Options;
import com.yd.question.service.dao.OptionsMapper;
import com.yd.question.service.model.RelObjectQuestionnaire;
import com.yd.question.service.service.IOptionsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 选项表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Service
public class OptionsServiceImpl extends ServiceImpl<OptionsMapper, Options> implements IOptionsService {

    /**
     * 根据问题业务id查询选项列表
     * @param optionBizId
     * @param optionBizIdList
     * @return
     */
    @Override
    public List<Options> queryList(String optionBizId,List<String> optionBizIdList) {
        List<Options> list = baseMapper.selectList(new LambdaQueryWrapper<Options>()
                .eq(StringUtils.isNotBlank(optionBizId),Options::getOptionBizId,optionBizId)
                .in(!CollectionUtils.isEmpty(optionBizIdList),Options::getOptionBizId,optionBizIdList)
        );
        return list;
    }

}
