package com.yd.question.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 答题会话表
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Getter
@Setter
@TableName("answer_sessions")
public class AnswerSessions implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 答题会话唯一业务ID
     */
    @TableField("session_id")
    private String sessionId;

    /**
     * 答题的对象业务ID
     */
    @TableField("object_biz_id")
    private String objectBizId;

    /**
     * 答题选择的问卷唯一业务ID
     */
    @TableField("questionnaire_biz_id")
    private String questionnaireBizId;

    /**
     * 答题选择的问题唯一业务ID
     */
    @TableField("question_biz_id")
    private String questionBizId;

    /**
     * 答题问题内容
     */
    @TableField("question_text")
    private String questionText;

    /**
     * 答题选择的选项json（包含附加问题答题内容）, 例：[{"option_biz_id": "option_1001","text": "是",[{"add_questions_biz_id": "add_1001","text": "5年"}]},]
     */
    @TableField("option_json")
    private String optionJson;

    /**
     * 答题状态(0:草稿 1:已完成 2:未完成)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
