package com.yd.question.feign.dto;

import lombok.Data;

@Data
public class ApiRelQuestionsGroupDto {

    //========以下是问卷问题关联表信息=========
    /**
     * 问卷问题关联表主键id
     */
    private Long relQuestionnaireQuestionsId;

    /**
     * 问卷唯一业务ID
     */
    private String questionnaireBizId;

    /**
     * 问题分组唯一业务ID
     */
    private String groupBizId;

    /**
     * 问题唯一业务ID
     */
    private String questionBizId;

    /**
     * 问题或者组在问卷中的顺序
     */
    private Integer relQuestionnaireQuestionsSortOrder;


    //========以下是问题分组和问题关联表信息=========
    /**
     * 问题分组和问题关联表主键id
     */
    private Long relQuestionsGroupId;

    /**
     * 问题在组内的排序序号
     */
    private Integer relQuestionsGroupSortOrder;


    //========以下是问题表信息=========
    /**
     * 问题表主键id
     */
    private Long questionId;

    /**
     * 问题内容
     */
    private String text;

    /**
     * 问题类型(字典：单选/多选/文本/日期/数字)
     */
    private String type;

    /**
     * 一级分类（字典：投保人、受保人等）
     */
    private String firstCategory;

    /**
     * 二级分类(/病况/通用信息/医保卡使用/女性适用（下次生日年龄为12岁以上）/其他补充说明等)（字典）
     */
    private String secondCategory;

    /**
     * 是否必答 0-否 1-是
     */
    private Integer isRequired;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

}
