package com.yd.question.feign.request;

import com.yd.question.feign.dto.ApiAnswerSessionsDto;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
public class ApiAnswerSaveRequest {

    /**
     * 答题的对象业务ID（操作的业务对象，例：预约信息业务唯一ID）
     */
    @NotBlank(message = "答题的对象业务ID不能为空")
    private String objectBizId;

    /**
     * 答题选择的问卷唯一业务ID
     */
    @NotBlank(message = "答题选择的问卷唯一业务ID不能为空")
    private String questionnaireBizId;

    /**
     * 答题会话对象（实际回答问题的内容）集合，对象即ApiAnswerSessionsDto，一个对象一个问卷问题
     */
    private List<ApiAnswerSessionsDto> answerSessionsDtoList;
}
