package com.yd.question.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 答案表
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Getter
@Setter
@TableName("answers")
public class Answers implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 问题答案唯一业务ID
     */
    @TableField("answer_biz_id")
    private String answerBizId;

    /**
     * 关联问题唯一业务ID
     */
    @TableField("question_biz_id")
    private String questionBizId;

    /**
     * 选项答案值json
     */
    @TableField("option_value")
    private String optionValue;

    /**
     * 问答题答案值
     */
    @TableField("value")
    private String value;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
