package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.service.dto.AnswerSessionsDto;
import com.yd.question.service.model.AnswerSessions;
import com.yd.question.service.dao.AnswerSessionsMapper;
import com.yd.question.service.model.Options;
import com.yd.question.service.service.IAnswerSessionsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 答题会话表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Service
public class AnswerSessionsServiceImpl extends ServiceImpl<AnswerSessionsMapper, AnswerSessions> implements IAnswerSessionsService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<AnswerSessions> queryList(AnswerSessionsDto dto) {
        List<AnswerSessions> list = baseMapper.selectList(new LambdaQueryWrapper<AnswerSessions>()
                .eq(StringUtils.isNotBlank(dto.getCreatorId()),AnswerSessions::getCreatorId,dto.getCreatorId())
                .eq(StringUtils.isNotBlank(dto.getObjectBizId()),AnswerSessions::getObjectBizId,dto.getObjectBizId())
                .eq(StringUtils.isNotBlank(dto.getQuestionnaireBizId()),AnswerSessions::getQuestionnaireBizId,dto.getQuestionnaireBizId())
                .eq(StringUtils.isNotBlank(dto.getQuestionBizId()),AnswerSessions::getQuestionBizId,dto.getQuestionBizId())
        );
        return list;
    }

    /**
     * 根据条件删除
     * @param dto
     * @return
     */
    @Override
    public Boolean del(AnswerSessionsDto dto) {
        return this.remove(new LambdaQueryWrapper<AnswerSessions>()
                .eq(StringUtils.isNotBlank(dto.getCreatorId()),AnswerSessions::getCreatorId,dto.getCreatorId())
                .eq(StringUtils.isNotBlank(dto.getObjectBizId()),AnswerSessions::getObjectBizId,dto.getObjectBizId())
                .eq(StringUtils.isNotBlank(dto.getQuestionnaireBizId()),AnswerSessions::getQuestionnaireBizId,dto.getQuestionnaireBizId())
        );
    }

}
