package com.yd.question.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 选项表
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Getter
@Setter
@TableName("options")
public class Options implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 选项唯一业务ID
     */
    @TableField("option_biz_id")
    private String optionBizId;

    /**
     * 关联问题唯一业务ID
     */
    @TableField("question_biz_id")
    private String questionBizId;

    /**
     * 选项值
     */
    @TableField("value")
    private String value;

    /**
     * 选项显示文本
     */
    @TableField("text")
    private String text;

    /**
     * 当前选项是否有附加问题 0-否 1-是
     */
    @TableField("is_add")
    private Integer isAdd;

    /**
     * 选项排序序号
     */
    @TableField("sort_order")
    private Integer sortOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
