package com.yd.question.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 问题表
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Getter
@Setter
@TableName("questions")
public class Questions implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 问题唯一业务ID
     */
    @TableField("question_biz_id")
    private String questionBizId;

    /**
     * 问题内容
     */
    @TableField("text")
    private String text;

    /**
     * 问题类型(字典：单选/多选/文本/日期/数字)
     */
    @TableField("type")
    private String type;

    /**
     * 一级分类（字典：投保人、受保人等）
     */
    @TableField("first_category")
    private String firstCategory;

    /**
     * 二级分类(/病况/通用信息/医保卡使用/女性适用（下次生日年龄为12岁以上）/其他补充说明等)（字典）
     */
    @TableField("second_category")
    private String secondCategory;

    /**
     * 是否必答 0-否 1-是
     */
    @TableField("is_required")
    private Integer isRequired;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 排序序号
     */
    @TableField("sort_order")
    private Integer sortOrder;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
