package com.yd.question.api.controller;

import com.yd.common.result.Result;
import com.yd.question.api.service.ApiQuestionnairesService;
import com.yd.question.feign.client.ApiQuestionnairesFeignClient;
import com.yd.question.feign.request.ApiAnswerSaveRequest;
import com.yd.question.feign.response.ApiAnswerSaveResponse;
import com.yd.question.feign.response.ApiQuestionnairesDetailResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 问卷信息
 *
 * @author zxm
 * @since 2025-09-12
 */
@RestController
@RequestMapping("/questionnaires")
@Validated
public class ApiQuestionnairesController implements ApiQuestionnairesFeignClient {

    @Autowired
    private ApiQuestionnairesService apiQuestionnairesService;

    /**
     * 获取问卷详细信息-单个问卷详细详细
     * @param questionnaireBizId 问卷唯一业务ID
     * @param objectBizId 对象业务ID
     * @return
     */
    @Override
    public Result<ApiQuestionnairesDetailResponse> detail(String questionnaireBizId, String objectBizId) {
        return apiQuestionnairesService.detail(questionnaireBizId,objectBizId);
    }

    /**
     * 问卷-答题提交接口
     * @return
     */
    @Override
    public Result<ApiAnswerSaveResponse> answerSave(ApiAnswerSaveRequest request) {
        return apiQuestionnairesService.answerSave(request);
    }
}
