package com.yd.scrm.api;

import com.yd.common.constant.ServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication
@MapperScan("com.yd.**.mapper")
@EnableFeignClients(basePackages = "com.yd.scrm.api.**")
public class ScrmApiApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(ScrmApiApplication.class)
                .properties("spring.application.name=" + ServerNameConstants.ydScrmApi)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-scrm-api启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
