package com.yd.scrm.api.controller;

import com.yd.common.result.Result;
//import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * SCRM业务控制器
 */
@RestController
@RequestMapping("/scrm")
public class ScrmController {

    /**
     * 测试接口，需要认证
     */
    @GetMapping("/test")
    public Result<String> test() {
        return Result.success("SCRM API 测试成功");
    }

    /**
     * 需要特定角色才能访问
     */
    @GetMapping("/admin")
//    @PreAuthorize("hasRole('ADMIN')")
    public Result<String> adminOperation() {
        return Result.success("管理员操作成功");
    }

    /**
     * 需要特定权限才能访问
     */
    @GetMapping("/customer")
//    @RequirePermission("scrm:customer:view")
    public Result<String> viewCustomer() {
        return Result.success("查看客户信息成功");
    }
}
