/*
 * Decompiled with CFR 0.152.
 */
package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yd.user.service.entity.Role;
import com.yd.user.service.entity.User;
import com.yd.user.service.mapper.RoleMapper;
import com.yd.user.service.mapper.UserMapper;
import com.yd.user.service.service.UserService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.userMapper.selectByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("\u7528\u6237\u4e0d\u5b58\u5728: " + username);
        }
        List<Role> roles = this.roleMapper.selectByUserId(user.getId());
        user.setRoles(roles);
        return user;
    }

    @Override
    public User findByUsername(String username) {
        User user = this.userMapper.selectByUsername(username);
        if (user != null) {
            user.setRoles(this.roleMapper.selectByUserId(user.getId()));
        }
        return user;
    }

    @Override
    @Transactional
    public User register(User user) {
        User existUser = (User)this.userMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"username", (Object)user.getUsername()));
        if (existUser != null) {
            throw new RuntimeException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        this.userMapper.insert(user);
        return user;
    }

    @Override
    public User getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237");
        }
        Object principal = authentication.getPrincipal();
        String username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        return this.findByUsername(username);
    }
}

