package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysRoleService;
import com.yd.user.feign.client.sysrole.ApiSysRoleFeignClient;
import com.yd.user.feign.request.sysrole.ApiSysRoleAddRequest;
import com.yd.user.feign.request.sysrole.ApiSysRoleEditRequest;
import com.yd.user.feign.request.sysrole.ApiSysRolePageRequest;
import com.yd.user.feign.response.sysrole.ApiSysRoleDetailResponse;
import com.yd.user.feign.response.sysrole.ApiSysRolePageResponse;
import com.yd.user.service.service.ISysRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 角色信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysRole")
@Validated
public class ApiSysRoleController implements ApiSysRoleFeignClient {

    @Autowired
    private ApiSysRoleService apiSysRoleService;

    /**
     * 角色分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysRolePageResponse>> page(ApiSysRolePageRequest request) {
        return apiSysRoleService.page(request);
    }

    /**
     * 获取角色详情
     * @param roleBizId 角色唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysRoleDetailResponse> detail(String roleBizId) {
        return apiSysRoleService.detail(roleBizId);
    }

    /**
     * 添加角色
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysRoleAddRequest request) {
        return apiSysRoleService.add(request);
    }

    /**
     * 编辑角色
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysRoleEditRequest request) {
        return apiSysRoleService.edit(request);
    }

    /**
     * 删除角色（逻辑删除） TODO
     * @param roleBizId 角色唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String roleBizId) {
        return null;
    }

    /**
     * 编辑角色状态
     * @param roleBizId 角色唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String roleBizId, Integer status) {

        return apiSysRoleService.editStatus(roleBizId,status);
    }
}
