package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantDeptService;
import com.yd.user.feign.client.reltenantdept.ApiRelTenantDeptFeignClient;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptListAddRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptListPageRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptTreeListRequest;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeResponse;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptListPageResponse;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptTreeListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * 租户-部门关系信息（租户管理-部门配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relTenantDept")
@Validated
public class ApiRelTenantDeptController implements ApiRelTenantDeptFeignClient {

    @Autowired
    private ApiRelTenantDeptService apiRelTenantDeptService;

    /**
     * 租户和部门关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantDeptListPageResponse>> page(ApiRelTenantDeptListPageRequest request) {
        return apiRelTenantDeptService.page(request);
    }

    /**
     * 租户和部门关系树形列表查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelTenantDeptTreeListResponse>> tree(ApiRelTenantDeptTreeListRequest request) {
        return apiRelTenantDeptService.tree(request);
    }

    /**
     * 添加租户和部门列表关系
     * @param request
     * @return
     */
    @Override
    public Result addDeptList(ApiRelTenantDeptListAddRequest request) {
        return apiRelTenantDeptService.addDeptList(request);
    }

    /**
     * 删除租户和部门关系
     * @param id 租户和部门关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelTenantDeptService.del(id);
    }

    /**
     * 导入-树形部门查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelTenantDeptImportQueryDeptTreeResponse>> importQueryDeptTree(ApiRelTenantDeptImportQueryDeptTreeRequest request) {
        return apiRelTenantDeptService.importQueryDeptTree(request);
    }

    /**
     * 导入-树形部门-查询选中的部门id集合
     * @param tenantBizId
     * @return
     */
    @Override
    public Result<List<String>> selectedList(String tenantBizId) {
        return apiRelTenantDeptService.selectedList(tenantBizId);
    }
}
