package com.yd.user.feign.response.login;

import lombok.Data;

import java.util.List;

/**
 * 登录用户绑定的租户信息列表出参
 */
@Data
public class ApiLoginTenantResponse {

    /**
     * 租户基础信息
     */
    private ApiLoginTenantInfoResponse apiLoginTenantInfoResponse;

    /**
     * 租户绑定的项目列表信息
     */
    private List<ApiLoginProjectInfoResponse> apiLoginProjectInfoResponseList;

    /**
     * 当前登录用户绑定的租户被分配的菜单集合（当前租户用户菜单集合）
     */
    private List<ApiLoginMenuInfoResponse> apiLoginMenuInfoResponseList;

    /**
     * 当前登录用户绑定的租户被分配的角色编码集合（当前租户用户角色编码集合）
     */
    private List<String> roles;

    /**
     * 当前登录用户绑定的租户被分配的控制页面内的具体操作（按钮级权限）集合（当前租户用户所拥有的所有按钮及权限集合）
     */
    private List<String> permissions;
}
