package com.yd.user.feign.client.relprojectrole;


import com.yd.common.result.Result;
import com.yd.user.feign.fallback.relprojectrole.ApiRelProjectRoleFeignFallbackFactory;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListAddRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListPageRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleSelectPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotNull;

/**
 * 用户服务：项目-角色关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelProjectRoleFeignFallbackFactory.class)
public interface ApiRelProjectRoleFeignClient {

    /**
     * 项目和角色关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@Validated @RequestBody ApiRelProjectRoleListPageRequest request);

    /**
     * 添加项目和角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/role/list")
    Result addRoleList(@Validated @RequestBody ApiRelProjectRoleListAddRequest request);

    /**
     * 删除项目和角色关系
     * @param id 项目和角色关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "项目和角色关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-选择角色分页查询（查询当前项目级（当前所属项目绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）
     * @param request
     * @return
     */
    @PostMapping("/select/role/page")
    Result selectRolePage(@Validated @RequestBody ApiRelProjectRoleSelectPageRequest request);
}
