package com.yd.user.feign.client.sysproject;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysproject.ApiSysProjectFeignFallbackFactory;
import com.yd.user.feign.request.sysproject.ApiSysProjectAddRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectEditRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectListRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectPageRequest;
import com.yd.user.feign.response.sysproject.ApiSysProjectDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务-系统项目信息Feign客户端
 */
@FeignClient(name = "yd-user-api",path = "/user/api/sysProject",fallbackFactory = ApiSysProjectFeignFallbackFactory.class)
public interface ApiSysProjectFeignClient {

    /**
     * 项目分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysProjectPageRequest request);

    /**
     * 项目列表查询
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiSysProjectDetailResponse>> list(@RequestBody ApiSysProjectListRequest request);

    /**
     * 获取项目详情
     * @param projectBizId 项目唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysProjectDetailResponse> detail(@NotBlank(message = "项目唯一标识(业务ID)不能为空") @RequestParam(value = "projectBizId") String projectBizId);

    /**
     * 添加项目
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSysProjectAddRequest request);

    /**
     * 编辑项目
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSysProjectEditRequest request);


    /**
     * 删除项目（逻辑删除）
     * @param projectBizId 项目唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "projectBizId") String projectBizId);

    /**
     * 编辑项目状态
     * @param projectBizId 项目唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "项目唯一标识(业务ID)不能为空") @RequestParam(value = "projectBizId") String projectBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);

}
