package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelDeptUserService;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserDelRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportAddRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportPageRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserPageRequest;
import com.yd.user.feign.response.reldeptuser.ApiRelTenantDeptUserImportPageResponse;
import com.yd.user.feign.response.reldeptuser.ApiRelTenantDeptUserPageResponse;
import com.yd.user.service.model.RelDeptUser;
import com.yd.user.service.model.RelProjectUser;
import com.yd.user.service.service.IRelDeptUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;


@Service
public class ApiRelDeptUserServiceImpl implements ApiRelDeptUserService {

    @Autowired
    private IRelDeptUserService iRelDeptUserService;

    /**
     * 租户管理-分配权限-部门配置-用户列表
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantDeptUserPageResponse>> page(ApiRelTenantDeptUserPageRequest request) {
        Page<ApiRelTenantDeptUserPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantDeptUserPageResponse> iPage = iRelDeptUserService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 租户管理-分配权限-部门配置-用户列表删除
     * @param request
     * @return
     */
    @Override
    public Result del(ApiRelTenantDeptUserDelRequest request) {
        RelDeptUser relDeptUser = iRelDeptUserService.queryOne(request.getId());
        if (Objects.isNull(relDeptUser)) {
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }

        iRelDeptUserService.removeById(request.getId());
        return Result.success();
    }

    /**
     * 租户管理-分配权限-部门配置-用户列表导入分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantDeptUserImportPageResponse>> importPage(ApiRelTenantDeptUserImportPageRequest request) {
        Page<ApiRelTenantDeptUserImportPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantDeptUserImportPageResponse> iPage = iRelDeptUserService.importPage(page, request);
        return Result.success(iPage);
    }

    /**
     * 租户管理-分配权限-部门配置-用户列表导入添加
     * @param request
     * @return
     */
    @Override
    public Result importAdd(ApiRelTenantDeptUserImportAddRequest request) {
        List<RelDeptUser> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(request.getUserBizIdList())) {
            //用户唯一标识(业务ID) 列表（选中列表）不为空
            list = request.getUserBizIdList().stream().map(bizId -> {
                RelDeptUser relDeptUser = new RelDeptUser();
                relDeptUser.setTenantBizId(request.getTenantBizId());
                relDeptUser.setDeptBizId(request.getDeptBizId());
                relDeptUser.setUserBizId(bizId);
                return relDeptUser;
            }).collect(Collectors.toList());

            iRelDeptUserService.saveOrUpdateBatch(list);
        }

        return Result.success();
    }
}
