package com.yd.user.feign.client.reltenantuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reltenantuser.ApiRelTenantUserFeignFallbackFactory;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListAddRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotNull;

/**
 * 用户服务：租户-用户关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelTenantUserFeignFallbackFactory.class)
public interface ApiRelTenantUserFeignClient {

    /**
     * 租户和用户关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@Validated @RequestBody ApiRelTenantUserListPageRequest request);

    /**
     * 添加租户和用户列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/user/list")
    Result addUserList(@Validated @RequestBody ApiRelTenantUserListAddRequest request);

    /**
     * 删除租户和用户关系
     * @param id 租户和用户关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "租户和用户关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前租户用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @PostMapping("/select/user/page")
    Result selectUserPage(@Validated @RequestBody ApiRelTenantUserSelectPageRequest request);

}
