package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.user.service.dto.SysDictItemDto;
import com.yd.user.service.model.RelTenantUser;
import com.yd.user.service.model.SysDictItem;
import com.yd.user.service.dao.SysDictItemMapper;
import com.yd.user.service.service.ISysDictItemService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 字典数据表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class SysDictItemServiceImpl extends ServiceImpl<SysDictItemMapper, SysDictItem> implements ISysDictItemService {

    /**
     * 根据条件查询列表
     * @param dto
     * @return
     */
    @Override
    public List<SysDictItem> queryList(SysDictItemDto dto) {
        List<SysDictItem> list = baseMapper.selectList(new LambdaQueryWrapper<SysDictItem>()
                .eq(!Objects.isNull(dto.getId()),SysDictItem::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getDictBizId()),SysDictItem::getDictBizId,dto.getDictBizId())
                .eq(StringUtils.isNotBlank(dto.getDictItemBizId()),SysDictItem::getDictItemBizId,dto.getDictItemBizId())
                .in(!CollectionUtils.isEmpty(dto.getDictBizIdList()),SysDictItem::getDictBizId,dto.getDictBizIdList())
        );
        return list;
    }
}
