package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantUserService;
import com.yd.user.feign.client.reltenantuser.ApiRelTenantUserFeignClient;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListAddRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserListPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserSelectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * 租户-用户关系信息（租户管理-用户配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relTenantUser")
@Validated
public class ApiRelTenantUserController implements ApiRelTenantUserFeignClient {

    @Autowired
    private ApiRelTenantUserService apiRelTenantUserService;

    /**
     * 租户和用户关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantUserListPageResponse>> page(ApiRelTenantUserListPageRequest request) {
        return apiRelTenantUserService.page(request);
    }

    /**
     * 添加租户和用户列表关系
     * @param request
     * @return
     */
    @Override
    public Result addUserList(ApiRelTenantUserListAddRequest request) {
        return apiRelTenantUserService.addUserList(request);
    }

    /**
     * 删除租户和用户关系
     * @param id 租户和用户关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelTenantUserService.del(id);
    }

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前租户用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantUserSelectPageResponse>> selectUserPage(ApiRelTenantUserSelectPageRequest request) {
        return apiRelTenantUserService.selectUserPage(request);
    }
}
