package com.yd.user.api.service.impl;

import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysDictService;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import com.yd.user.service.dto.SysDictItemDto;
import com.yd.user.service.model.SysDict;
import com.yd.user.service.model.SysDictItem;
import com.yd.user.service.service.ISysDictItemService;
import com.yd.user.service.service.ISysDictService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ApiSysDictServiceImpl implements ApiSysDictService {

    @Autowired
    private ISysDictService iSysDictService;

    @Autowired
    private ISysDictItemService iSysDictItemService;

    /**
     * 根据字典类型获取字典数据项列表
     * @param dictType
     * @return
     */
    @Override
    public Result<List<GetDictItemListByDictTypeResponse>> getDictItemListByDictType(String dictType) {
        SysDict sysDict = iSysDictService.queryOneByType(dictType);
        if (Objects.isNull(sysDict)) {
            throw new BusinessException("字典类型数据不存在");
        }

        List<GetDictItemListByDictTypeResponse> responses = new ArrayList<>();
        //查询字典数据项列表
        List<SysDictItem> sysDictItemList = iSysDictItemService.queryList(SysDictItemDto.builder()
                .dictBizId(sysDict.getDictBizId())
                .build());
        if (!CollectionUtils.isEmpty(sysDictItemList)) {
            responses = sysDictItemList.stream().map(dto -> {
                GetDictItemListByDictTypeResponse response = new GetDictItemListByDictTypeResponse();
                BeanUtils.copyProperties(dto,response);
                return response;
            }).collect(Collectors.toList());
        }

        return Result.success(responses);
    }
}
